function [residual, g1, g2, g3] = World_Economy_Cartel_cost_inv_shocks_objective_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 1, 1);

%
% Model equations
%

T18 = exp(y(19))-params(9)*exp(y(18))^(1+params(8))/(1+params(8));
T21 = T18^(-params(14));
T37 = exp(y(4))*exp(y(27))*params(6)*exp(y(34))^(params(5)-1);
T38 = exp(y(4))*exp(y(1))-T37;
T44 = T38-exp(y(25))*exp(y(2));
residual(1) = T21*T44;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(1, 76);

  %
  % Jacobian matrix
  %

T49 = T21*(-(exp(y(25))*exp(y(2))));
T52 = exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),1);
T55 = (-(params(9)*T52/(1+params(8))));
T56 = getPowerDeriv(T18,(-params(14)),1);
T57 = T55*T56;
T64 = exp(y(34))*getPowerDeriv(exp(y(34)),params(5)-1,1);
T67 = (-(exp(y(4))*exp(y(27))*params(6)*T64));
T68 = T21*T67;
  g1(1,1)=T21*exp(y(4))*exp(y(1));
  g1(1,2)=T49;
  g1(1,4)=T21*T38;
  g1(1,18)=T44*T57;
  g1(1,19)=T44*exp(y(19))*T56;
  g1(1,25)=T49;
  g1(1,27)=T21*(-T37);
  g1(1,34)=T68;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  v2 = zeros(44,3);
T73 = exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),2);
T74 = exp(y(18))*T73;
T75 = T52+T74;
T78 = (-(params(9)*T75/(1+params(8))));
T79 = getPowerDeriv(T18,(-params(14)),2);
T80 = T55*T79;
T83 = T56*T78+T55*T80;
T86 = (-(exp(y(25))*exp(y(2))))*exp(y(19))*T56;
T92 = exp(y(19))*T56+exp(y(19))*exp(y(19))*T79;
T99 = exp(y(34))*getPowerDeriv(exp(y(34)),params(5)-1,2);
T100 = exp(y(34))*T99;
T101 = T64+T100;
T104 = (-(exp(y(4))*exp(y(27))*params(6)*T101));
T105 = T21*T104;
  v2(1,1)=1;
  v2(1,2)=1;
  v2(1,3)=T21*exp(y(4))*exp(y(1));
  v2(2,1)=1;
  v2(2,2)=78;
  v2(2,3)=T49;
  v2(3,1)=1;
  v2(3,2)=229;
  v2(3,3)=T21*exp(y(4))*exp(y(1));
  v2(4,1)=1;
  v2(4,2)=4;
  v2(4,3)=  v2(3,3);
  v2(5,1)=1;
  v2(5,2)=232;
  v2(5,3)=T21*T38;
  v2(6,1)=1;
  v2(6,2)=1293;
  v2(6,3)=exp(y(4))*exp(y(1))*T57;
  v2(7,1)=1;
  v2(7,2)=18;
  v2(7,3)=  v2(6,3);
  v2(8,1)=1;
  v2(8,2)=1294;
  v2(8,3)=(-(exp(y(25))*exp(y(2))))*T57;
  v2(9,1)=1;
  v2(9,2)=94;
  v2(9,3)=  v2(8,3);
  v2(10,1)=1;
  v2(10,2)=1296;
  v2(10,3)=T38*T57;
  v2(11,1)=1;
  v2(11,2)=246;
  v2(11,3)=  v2(10,3);
  v2(12,1)=1;
  v2(12,2)=1310;
  v2(12,3)=T44*T83;
  v2(13,1)=1;
  v2(13,2)=1369;
  v2(13,3)=exp(y(4))*exp(y(1))*exp(y(19))*T56;
  v2(14,1)=1;
  v2(14,2)=19;
  v2(14,3)=  v2(13,3);
  v2(15,1)=1;
  v2(15,2)=1370;
  v2(15,3)=T86;
  v2(16,1)=1;
  v2(16,2)=95;
  v2(16,3)=  v2(15,3);
  v2(17,1)=1;
  v2(17,2)=1372;
  v2(17,3)=T38*exp(y(19))*T56;
  v2(18,1)=1;
  v2(18,2)=247;
  v2(18,3)=  v2(17,3);
  v2(19,1)=1;
  v2(19,2)=1386;
  v2(19,3)=T44*exp(y(19))*T80;
  v2(20,1)=1;
  v2(20,2)=1311;
  v2(20,3)=  v2(19,3);
  v2(21,1)=1;
  v2(21,2)=1387;
  v2(21,3)=T44*T92;
  v2(22,1)=1;
  v2(22,2)=1826;
  v2(22,3)=T49;
  v2(23,1)=1;
  v2(23,2)=101;
  v2(23,3)=  v2(22,3);
  v2(24,1)=1;
  v2(24,2)=1842;
  v2(24,3)=(-(exp(y(25))*exp(y(2))))*T57;
  v2(25,1)=1;
  v2(25,2)=1317;
  v2(25,3)=  v2(24,3);
  v2(26,1)=1;
  v2(26,2)=1843;
  v2(26,3)=T86;
  v2(27,1)=1;
  v2(27,2)=1393;
  v2(27,3)=  v2(26,3);
  v2(28,1)=1;
  v2(28,2)=1849;
  v2(28,3)=T49;
  v2(29,1)=1;
  v2(29,2)=1980;
  v2(29,3)=T21*(-T37);
  v2(30,1)=1;
  v2(30,2)=255;
  v2(30,3)=  v2(29,3);
  v2(31,1)=1;
  v2(31,2)=1994;
  v2(31,3)=T57*(-T37);
  v2(32,1)=1;
  v2(32,2)=1319;
  v2(32,3)=  v2(31,3);
  v2(33,1)=1;
  v2(33,2)=1995;
  v2(33,3)=exp(y(19))*T56*(-T37);
  v2(34,1)=1;
  v2(34,2)=1395;
  v2(34,3)=  v2(33,3);
  v2(35,1)=1;
  v2(35,2)=2003;
  v2(35,3)=T21*(-T37);
  v2(36,1)=1;
  v2(36,2)=2512;
  v2(36,3)=T68;
  v2(37,1)=1;
  v2(37,2)=262;
  v2(37,3)=  v2(36,3);
  v2(38,1)=1;
  v2(38,2)=2526;
  v2(38,3)=T57*T67;
  v2(39,1)=1;
  v2(39,2)=1326;
  v2(39,3)=  v2(38,3);
  v2(40,1)=1;
  v2(40,2)=2527;
  v2(40,3)=exp(y(19))*T56*T67;
  v2(41,1)=1;
  v2(41,2)=1402;
  v2(41,3)=  v2(40,3);
  v2(42,1)=1;
  v2(42,2)=2535;
  v2(42,3)=T68;
  v2(43,1)=1;
  v2(43,2)=2010;
  v2(43,3)=  v2(42,3);
  v2(44,1)=1;
  v2(44,2)=2542;
  v2(44,3)=T105;
  g2 = sparse(v2(:,1),v2(:,2),v2(:,3),1,5776);
if nargout >= 4,
  %
  % Third order derivatives
  %

  v3 = zeros(218,3);
T122 = getPowerDeriv(T18,(-params(14)),3);
T123 = T55*T122;
T126 = T78*T79+T55*T123;
  v3(1,1)=1;
  v3(1,2)=1;
  v3(1,3)=T21*exp(y(4))*exp(y(1));
  v3(2,1)=1;
  v3(2,2)=5854;
  v3(2,3)=T49;
  v3(3,1)=1;
  v3(3,2)=17329;
  v3(3,3)=T21*exp(y(4))*exp(y(1));
  v3(4,1)=1;
  v3(4,2)=4;
  v3(4,3)=  v3(3,3);
  v3(5,1)=1;
  v3(5,2)=229;
  v3(5,3)=  v3(3,3);
  v3(6,1)=1;
  v3(6,2)=17557;
  v3(6,3)=T21*exp(y(4))*exp(y(1));
  v3(7,1)=1;
  v3(7,2)=232;
  v3(7,3)=  v3(6,3);
  v3(8,1)=1;
  v3(8,2)=17332;
  v3(8,3)=  v3(6,3);
  v3(9,1)=1;
  v3(9,2)=17560;
  v3(9,3)=T21*T38;
  v3(10,1)=1;
  v3(10,2)=98193;
  v3(10,3)=exp(y(4))*exp(y(1))*T57;
  v3(11,1)=1;
  v3(11,2)=18;
  v3(11,3)=  v3(10,3);
  v3(12,1)=1;
  v3(12,2)=1293;
  v3(12,3)=  v3(10,3);
  v3(13,1)=1;
  v3(13,2)=98270;
  v3(13,3)=(-(exp(y(25))*exp(y(2))))*T57;
  v3(14,1)=1;
  v3(14,2)=5870;
  v3(14,3)=  v3(13,3);
  v3(15,1)=1;
  v3(15,2)=7070;
  v3(15,3)=  v3(13,3);
  v3(16,1)=1;
  v3(16,2)=98421;
  v3(16,3)=exp(y(4))*exp(y(1))*T57;
  v3(17,1)=1;
  v3(17,2)=246;
  v3(17,3)=  v3(16,3);
  v3(18,1)=1;
  v3(18,2)=1296;
  v3(18,3)=  v3(16,3);
  v3(19,1)=1;
  v3(19,2)=17346;
  v3(19,3)=  v3(16,3);
  v3(20,1)=1;
  v3(20,2)=18621;
  v3(20,3)=  v3(16,3);
  v3(21,1)=1;
  v3(21,2)=98196;
  v3(21,3)=  v3(16,3);
  v3(22,1)=1;
  v3(22,2)=98424;
  v3(22,3)=T38*T57;
  v3(23,1)=1;
  v3(23,2)=17574;
  v3(23,3)=  v3(22,3);
  v3(24,1)=1;
  v3(24,2)=18624;
  v3(24,3)=  v3(22,3);
  v3(25,1)=1;
  v3(25,2)=99485;
  v3(25,3)=exp(y(4))*exp(y(1))*T83;
  v3(26,1)=1;
  v3(26,2)=1310;
  v3(26,3)=  v3(25,3);
  v3(27,1)=1;
  v3(27,2)=98210;
  v3(27,3)=  v3(25,3);
  v3(28,1)=1;
  v3(28,2)=99486;
  v3(28,3)=(-(exp(y(25))*exp(y(2))))*T83;
  v3(29,1)=1;
  v3(29,2)=7086;
  v3(29,3)=  v3(28,3);
  v3(30,1)=1;
  v3(30,2)=98286;
  v3(30,3)=  v3(28,3);
  v3(31,1)=1;
  v3(31,2)=99488;
  v3(31,3)=T38*T83;
  v3(32,1)=1;
  v3(32,2)=18638;
  v3(32,3)=  v3(31,3);
  v3(33,1)=1;
  v3(33,2)=98438;
  v3(33,3)=  v3(31,3);
  v3(34,1)=1;
  v3(34,2)=99502;
  v3(34,3)=T44*(T78*T80+T56*(-(params(9)*(T75+T74+exp(y(18))*(T73+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),3)))/(1+params(8))))+T78*T80+T55*T126);
  v3(35,1)=1;
  v3(35,2)=103969;
  v3(35,3)=exp(y(4))*exp(y(1))*exp(y(19))*T56;
  v3(36,1)=1;
  v3(36,2)=19;
  v3(36,3)=  v3(35,3);
  v3(37,1)=1;
  v3(37,2)=1369;
  v3(37,3)=  v3(35,3);
  v3(38,1)=1;
  v3(38,2)=104046;
  v3(38,3)=T86;
  v3(39,1)=1;
  v3(39,2)=5871;
  v3(39,3)=  v3(38,3);
  v3(40,1)=1;
  v3(40,2)=7146;
  v3(40,3)=  v3(38,3);
  v3(41,1)=1;
  v3(41,2)=104197;
  v3(41,3)=exp(y(4))*exp(y(1))*exp(y(19))*T56;
  v3(42,1)=1;
  v3(42,2)=247;
  v3(42,3)=  v3(41,3);
  v3(43,1)=1;
  v3(43,2)=1372;
  v3(43,3)=  v3(41,3);
  v3(44,1)=1;
  v3(44,2)=17347;
  v3(44,3)=  v3(41,3);
  v3(45,1)=1;
  v3(45,2)=18697;
  v3(45,3)=  v3(41,3);
  v3(46,1)=1;
  v3(46,2)=103972;
  v3(46,3)=  v3(41,3);
  v3(47,1)=1;
  v3(47,2)=104200;
  v3(47,3)=T38*exp(y(19))*T56;
  v3(48,1)=1;
  v3(48,2)=17575;
  v3(48,3)=  v3(47,3);
  v3(49,1)=1;
  v3(49,2)=18700;
  v3(49,3)=  v3(47,3);
  v3(50,1)=1;
  v3(50,2)=105261;
  v3(50,3)=exp(y(4))*exp(y(1))*exp(y(19))*T80;
  v3(51,1)=1;
  v3(51,2)=1311;
  v3(51,3)=  v3(50,3);
  v3(52,1)=1;
  v3(52,2)=1386;
  v3(52,3)=  v3(50,3);
  v3(53,1)=1;
  v3(53,2)=98211;
  v3(53,3)=  v3(50,3);
  v3(54,1)=1;
  v3(54,2)=99561;
  v3(54,3)=  v3(50,3);
  v3(55,1)=1;
  v3(55,2)=103986;
  v3(55,3)=  v3(50,3);
  v3(56,1)=1;
  v3(56,2)=105262;
  v3(56,3)=(-(exp(y(25))*exp(y(2))))*exp(y(19))*T80;
  v3(57,1)=1;
  v3(57,2)=7087;
  v3(57,3)=  v3(56,3);
  v3(58,1)=1;
  v3(58,2)=7162;
  v3(58,3)=  v3(56,3);
  v3(59,1)=1;
  v3(59,2)=98287;
  v3(59,3)=  v3(56,3);
  v3(60,1)=1;
  v3(60,2)=99562;
  v3(60,3)=  v3(56,3);
  v3(61,1)=1;
  v3(61,2)=104062;
  v3(61,3)=  v3(56,3);
  v3(62,1)=1;
  v3(62,2)=105264;
  v3(62,3)=T38*exp(y(19))*T80;
  v3(63,1)=1;
  v3(63,2)=18639;
  v3(63,3)=  v3(62,3);
  v3(64,1)=1;
  v3(64,2)=18714;
  v3(64,3)=  v3(62,3);
  v3(65,1)=1;
  v3(65,2)=98439;
  v3(65,3)=  v3(62,3);
  v3(66,1)=1;
  v3(66,2)=99564;
  v3(66,3)=  v3(62,3);
  v3(67,1)=1;
  v3(67,2)=104214;
  v3(67,3)=  v3(62,3);
  v3(68,1)=1;
  v3(68,2)=105278;
  v3(68,3)=T44*exp(y(19))*T126;
  v3(69,1)=1;
  v3(69,2)=99503;
  v3(69,3)=  v3(68,3);
  v3(70,1)=1;
  v3(70,2)=99578;
  v3(70,3)=  v3(68,3);
  v3(71,1)=1;
  v3(71,2)=105337;
  v3(71,3)=exp(y(4))*exp(y(1))*T92;
  v3(72,1)=1;
  v3(72,2)=1387;
  v3(72,3)=  v3(71,3);
  v3(73,1)=1;
  v3(73,2)=103987;
  v3(73,3)=  v3(71,3);
  v3(74,1)=1;
  v3(74,2)=105338;
  v3(74,3)=(-(exp(y(25))*exp(y(2))))*T92;
  v3(75,1)=1;
  v3(75,2)=7163;
  v3(75,3)=  v3(74,3);
  v3(76,1)=1;
  v3(76,2)=104063;
  v3(76,3)=  v3(74,3);
  v3(77,1)=1;
  v3(77,2)=105340;
  v3(77,3)=T38*T92;
  v3(78,1)=1;
  v3(78,2)=18715;
  v3(78,3)=  v3(77,3);
  v3(79,1)=1;
  v3(79,2)=104215;
  v3(79,3)=  v3(77,3);
  v3(80,1)=1;
  v3(80,2)=105354;
  v3(80,3)=T44*(exp(y(19))*T80+exp(y(19))*exp(y(19))*T123);
  v3(81,1)=1;
  v3(81,2)=99579;
  v3(81,3)=  v3(80,3);
  v3(82,1)=1;
  v3(82,2)=105279;
  v3(82,3)=  v3(80,3);
  v3(83,1)=1;
  v3(83,2)=105355;
  v3(83,3)=T44*(T92+exp(y(19))*exp(y(19))*T79+exp(y(19))*(exp(y(19))*T79+exp(y(19))*exp(y(19))*T122));
  v3(84,1)=1;
  v3(84,2)=138702;
  v3(84,3)=T49;
  v3(85,1)=1;
  v3(85,2)=5877;
  v3(85,3)=  v3(84,3);
  v3(86,1)=1;
  v3(86,2)=7602;
  v3(86,3)=  v3(84,3);
  v3(87,1)=1;
  v3(87,2)=139918;
  v3(87,3)=(-(exp(y(25))*exp(y(2))))*T57;
  v3(88,1)=1;
  v3(88,2)=7093;
  v3(88,3)=  v3(87,3);
  v3(89,1)=1;
  v3(89,2)=7618;
  v3(89,3)=  v3(87,3);
  v3(90,1)=1;
  v3(90,2)=98293;
  v3(90,3)=  v3(87,3);
  v3(91,1)=1;
  v3(91,2)=100018;
  v3(91,3)=  v3(87,3);
  v3(92,1)=1;
  v3(92,2)=138718;
  v3(92,3)=  v3(87,3);
  v3(93,1)=1;
  v3(93,2)=139934;
  v3(93,3)=(-(exp(y(25))*exp(y(2))))*T83;
  v3(94,1)=1;
  v3(94,2)=99509;
  v3(94,3)=  v3(93,3);
  v3(95,1)=1;
  v3(95,2)=100034;
  v3(95,3)=  v3(93,3);
  v3(96,1)=1;
  v3(96,2)=139994;
  v3(96,3)=T86;
  v3(97,1)=1;
  v3(97,2)=7169;
  v3(97,3)=  v3(96,3);
  v3(98,1)=1;
  v3(98,2)=7619;
  v3(98,3)=  v3(96,3);
  v3(99,1)=1;
  v3(99,2)=104069;
  v3(99,3)=  v3(96,3);
  v3(100,1)=1;
  v3(100,2)=105794;
  v3(100,3)=  v3(96,3);
  v3(101,1)=1;
  v3(101,2)=138719;
  v3(101,3)=  v3(96,3);
  v3(102,1)=1;
  v3(102,2)=140010;
  v3(102,3)=(-(exp(y(25))*exp(y(2))))*exp(y(19))*T80;
  v3(103,1)=1;
  v3(103,2)=99585;
  v3(103,3)=  v3(102,3);
  v3(104,1)=1;
  v3(104,2)=100035;
  v3(104,3)=  v3(102,3);
  v3(105,1)=1;
  v3(105,2)=105285;
  v3(105,3)=  v3(102,3);
  v3(106,1)=1;
  v3(106,2)=105810;
  v3(106,3)=  v3(102,3);
  v3(107,1)=1;
  v3(107,2)=139935;
  v3(107,3)=  v3(102,3);
  v3(108,1)=1;
  v3(108,2)=140011;
  v3(108,3)=(-(exp(y(25))*exp(y(2))))*T92;
  v3(109,1)=1;
  v3(109,2)=105361;
  v3(109,3)=  v3(108,3);
  v3(110,1)=1;
  v3(110,2)=105811;
  v3(110,3)=  v3(108,3);
  v3(111,1)=1;
  v3(111,2)=140450;
  v3(111,3)=T49;
  v3(112,1)=1;
  v3(112,2)=7625;
  v3(112,3)=  v3(111,3);
  v3(113,1)=1;
  v3(113,2)=138725;
  v3(113,3)=  v3(111,3);
  v3(114,1)=1;
  v3(114,2)=140466;
  v3(114,3)=(-(exp(y(25))*exp(y(2))))*T57;
  v3(115,1)=1;
  v3(115,2)=100041;
  v3(115,3)=  v3(114,3);
  v3(116,1)=1;
  v3(116,2)=139941;
  v3(116,3)=  v3(114,3);
  v3(117,1)=1;
  v3(117,2)=140467;
  v3(117,3)=T86;
  v3(118,1)=1;
  v3(118,2)=105817;
  v3(118,3)=  v3(117,3);
  v3(119,1)=1;
  v3(119,2)=140017;
  v3(119,3)=  v3(117,3);
  v3(120,1)=1;
  v3(120,2)=140473;
  v3(120,3)=T49;
  v3(121,1)=1;
  v3(121,2)=150408;
  v3(121,3)=T21*(-T37);
  v3(122,1)=1;
  v3(122,2)=17583;
  v3(122,3)=  v3(121,3);
  v3(123,1)=1;
  v3(123,2)=19308;
  v3(123,3)=  v3(121,3);
  v3(124,1)=1;
  v3(124,2)=151472;
  v3(124,3)=T57*(-T37);
  v3(125,1)=1;
  v3(125,2)=18647;
  v3(125,3)=  v3(124,3);
  v3(126,1)=1;
  v3(126,2)=19322;
  v3(126,3)=  v3(124,3);
  v3(127,1)=1;
  v3(127,2)=98447;
  v3(127,3)=  v3(124,3);
  v3(128,1)=1;
  v3(128,2)=100172;
  v3(128,3)=  v3(124,3);
  v3(129,1)=1;
  v3(129,2)=150422;
  v3(129,3)=  v3(124,3);
  v3(130,1)=1;
  v3(130,2)=151486;
  v3(130,3)=(-T37)*T83;
  v3(131,1)=1;
  v3(131,2)=99511;
  v3(131,3)=  v3(130,3);
  v3(132,1)=1;
  v3(132,2)=100186;
  v3(132,3)=  v3(130,3);
  v3(133,1)=1;
  v3(133,2)=151548;
  v3(133,3)=exp(y(19))*T56*(-T37);
  v3(134,1)=1;
  v3(134,2)=18723;
  v3(134,3)=  v3(133,3);
  v3(135,1)=1;
  v3(135,2)=19323;
  v3(135,3)=  v3(133,3);
  v3(136,1)=1;
  v3(136,2)=104223;
  v3(136,3)=  v3(133,3);
  v3(137,1)=1;
  v3(137,2)=105948;
  v3(137,3)=  v3(133,3);
  v3(138,1)=1;
  v3(138,2)=150423;
  v3(138,3)=  v3(133,3);
  v3(139,1)=1;
  v3(139,2)=151562;
  v3(139,3)=(-T37)*exp(y(19))*T80;
  v3(140,1)=1;
  v3(140,2)=99587;
  v3(140,3)=  v3(139,3);
  v3(141,1)=1;
  v3(141,2)=100187;
  v3(141,3)=  v3(139,3);
  v3(142,1)=1;
  v3(142,2)=105287;
  v3(142,3)=  v3(139,3);
  v3(143,1)=1;
  v3(143,2)=105962;
  v3(143,3)=  v3(139,3);
  v3(144,1)=1;
  v3(144,2)=151487;
  v3(144,3)=  v3(139,3);
  v3(145,1)=1;
  v3(145,2)=151563;
  v3(145,3)=(-T37)*T92;
  v3(146,1)=1;
  v3(146,2)=105363;
  v3(146,3)=  v3(145,3);
  v3(147,1)=1;
  v3(147,2)=105963;
  v3(147,3)=  v3(145,3);
  v3(148,1)=1;
  v3(148,2)=152156;
  v3(148,3)=T21*(-T37);
  v3(149,1)=1;
  v3(149,2)=19331;
  v3(149,3)=  v3(148,3);
  v3(150,1)=1;
  v3(150,2)=150431;
  v3(150,3)=  v3(148,3);
  v3(151,1)=1;
  v3(151,2)=152170;
  v3(151,3)=T57*(-T37);
  v3(152,1)=1;
  v3(152,2)=100195;
  v3(152,3)=  v3(151,3);
  v3(153,1)=1;
  v3(153,2)=151495;
  v3(153,3)=  v3(151,3);
  v3(154,1)=1;
  v3(154,2)=152171;
  v3(154,3)=exp(y(19))*T56*(-T37);
  v3(155,1)=1;
  v3(155,2)=105971;
  v3(155,3)=  v3(154,3);
  v3(156,1)=1;
  v3(156,2)=151571;
  v3(156,3)=  v3(154,3);
  v3(157,1)=1;
  v3(157,2)=152179;
  v3(157,3)=T21*(-T37);
  v3(158,1)=1;
  v3(158,2)=190840;
  v3(158,3)=T68;
  v3(159,1)=1;
  v3(159,2)=17590;
  v3(159,3)=  v3(158,3);
  v3(160,1)=1;
  v3(160,2)=19840;
  v3(160,3)=  v3(158,3);
  v3(161,1)=1;
  v3(161,2)=191904;
  v3(161,3)=T57*T67;
  v3(162,1)=1;
  v3(162,2)=18654;
  v3(162,3)=  v3(161,3);
  v3(163,1)=1;
  v3(163,2)=19854;
  v3(163,3)=  v3(161,3);
  v3(164,1)=1;
  v3(164,2)=98454;
  v3(164,3)=  v3(161,3);
  v3(165,1)=1;
  v3(165,2)=100704;
  v3(165,3)=  v3(161,3);
  v3(166,1)=1;
  v3(166,2)=190854;
  v3(166,3)=  v3(161,3);
  v3(167,1)=1;
  v3(167,2)=191918;
  v3(167,3)=T67*T83;
  v3(168,1)=1;
  v3(168,2)=99518;
  v3(168,3)=  v3(167,3);
  v3(169,1)=1;
  v3(169,2)=100718;
  v3(169,3)=  v3(167,3);
  v3(170,1)=1;
  v3(170,2)=191980;
  v3(170,3)=exp(y(19))*T56*T67;
  v3(171,1)=1;
  v3(171,2)=18730;
  v3(171,3)=  v3(170,3);
  v3(172,1)=1;
  v3(172,2)=19855;
  v3(172,3)=  v3(170,3);
  v3(173,1)=1;
  v3(173,2)=104230;
  v3(173,3)=  v3(170,3);
  v3(174,1)=1;
  v3(174,2)=106480;
  v3(174,3)=  v3(170,3);
  v3(175,1)=1;
  v3(175,2)=190855;
  v3(175,3)=  v3(170,3);
  v3(176,1)=1;
  v3(176,2)=191994;
  v3(176,3)=T67*exp(y(19))*T80;
  v3(177,1)=1;
  v3(177,2)=99594;
  v3(177,3)=  v3(176,3);
  v3(178,1)=1;
  v3(178,2)=100719;
  v3(178,3)=  v3(176,3);
  v3(179,1)=1;
  v3(179,2)=105294;
  v3(179,3)=  v3(176,3);
  v3(180,1)=1;
  v3(180,2)=106494;
  v3(180,3)=  v3(176,3);
  v3(181,1)=1;
  v3(181,2)=191919;
  v3(181,3)=  v3(176,3);
  v3(182,1)=1;
  v3(182,2)=191995;
  v3(182,3)=T67*T92;
  v3(183,1)=1;
  v3(183,2)=105370;
  v3(183,3)=  v3(182,3);
  v3(184,1)=1;
  v3(184,2)=106495;
  v3(184,3)=  v3(182,3);
  v3(185,1)=1;
  v3(185,2)=192588;
  v3(185,3)=T68;
  v3(186,1)=1;
  v3(186,2)=19338;
  v3(186,3)=  v3(185,3);
  v3(187,1)=1;
  v3(187,2)=19863;
  v3(187,3)=  v3(185,3);
  v3(188,1)=1;
  v3(188,2)=150438;
  v3(188,3)=  v3(185,3);
  v3(189,1)=1;
  v3(189,2)=152688;
  v3(189,3)=  v3(185,3);
  v3(190,1)=1;
  v3(190,2)=190863;
  v3(190,3)=  v3(185,3);
  v3(191,1)=1;
  v3(191,2)=192602;
  v3(191,3)=T57*T67;
  v3(192,1)=1;
  v3(192,2)=100202;
  v3(192,3)=  v3(191,3);
  v3(193,1)=1;
  v3(193,2)=100727;
  v3(193,3)=  v3(191,3);
  v3(194,1)=1;
  v3(194,2)=151502;
  v3(194,3)=  v3(191,3);
  v3(195,1)=1;
  v3(195,2)=152702;
  v3(195,3)=  v3(191,3);
  v3(196,1)=1;
  v3(196,2)=191927;
  v3(196,3)=  v3(191,3);
  v3(197,1)=1;
  v3(197,2)=192603;
  v3(197,3)=exp(y(19))*T56*T67;
  v3(198,1)=1;
  v3(198,2)=105978;
  v3(198,3)=  v3(197,3);
  v3(199,1)=1;
  v3(199,2)=106503;
  v3(199,3)=  v3(197,3);
  v3(200,1)=1;
  v3(200,2)=151578;
  v3(200,3)=  v3(197,3);
  v3(201,1)=1;
  v3(201,2)=152703;
  v3(201,3)=  v3(197,3);
  v3(202,1)=1;
  v3(202,2)=192003;
  v3(202,3)=  v3(197,3);
  v3(203,1)=1;
  v3(203,2)=192611;
  v3(203,3)=T68;
  v3(204,1)=1;
  v3(204,2)=152186;
  v3(204,3)=  v3(203,3);
  v3(205,1)=1;
  v3(205,2)=152711;
  v3(205,3)=  v3(203,3);
  v3(206,1)=1;
  v3(206,2)=193120;
  v3(206,3)=T105;
  v3(207,1)=1;
  v3(207,2)=19870;
  v3(207,3)=  v3(206,3);
  v3(208,1)=1;
  v3(208,2)=190870;
  v3(208,3)=  v3(206,3);
  v3(209,1)=1;
  v3(209,2)=193134;
  v3(209,3)=T57*T104;
  v3(210,1)=1;
  v3(210,2)=100734;
  v3(210,3)=  v3(209,3);
  v3(211,1)=1;
  v3(211,2)=191934;
  v3(211,3)=  v3(209,3);
  v3(212,1)=1;
  v3(212,2)=193135;
  v3(212,3)=exp(y(19))*T56*T104;
  v3(213,1)=1;
  v3(213,2)=106510;
  v3(213,3)=  v3(212,3);
  v3(214,1)=1;
  v3(214,2)=192010;
  v3(214,3)=  v3(212,3);
  v3(215,1)=1;
  v3(215,2)=193143;
  v3(215,3)=T105;
  v3(216,1)=1;
  v3(216,2)=152718;
  v3(216,3)=  v3(215,3);
  v3(217,1)=1;
  v3(217,2)=192618;
  v3(217,3)=  v3(215,3);
  v3(218,1)=1;
  v3(218,2)=193150;
  v3(218,3)=T21*(-(exp(y(4))*exp(y(27))*params(6)*(T101+T100+exp(y(34))*(T99+exp(y(34))*exp(y(34))*getPowerDeriv(exp(y(34)),params(5)-1,3)))));
  g3 = sparse(v3(:,1),v3(:,2),v3(:,3),1,438976);
end
end
end
end
